/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.business;

import ch.hearc.masict.jav.business.CellarBottle;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.table.AbstractTableModel;

public class CellarStatistics
extends AbstractTableModel {
    public static final String[] defaultStatsList = new String[]{STATISTICS.access$000(STATISTICS.TOT_BTLES), STATISTICS.access$000(STATISTICS.TOT_TAKEN_BTLES), STATISTICS.access$000(STATISTICS.TOT_TO_DRINK), STATISTICS.access$000(STATISTICS.TOT_PRICE)};
    public static final String[] statsList = new String[]{STATISTICS.access$000(STATISTICS.values()[0]), STATISTICS.access$000(STATISTICS.values()[1]), STATISTICS.access$000(STATISTICS.values()[2]), STATISTICS.access$000(STATISTICS.values()[3]), STATISTICS.access$000(STATISTICS.values()[4])};
    private String[] currentStatsList = defaultStatsList;
    private int totalNbBottles = 0;
    private int totalNbBottlesTaken = 0;
    private int totalNbBottlesToDrink = 0;
    private int totalQuantity = 0;
    private double totalPrice = 0.0;
    private HashMap<String, Integer> totalNbPerCountries = new HashMap();
    private HashMap<String, Integer> totalNbPerRegions = new HashMap();
    private HashMap<String, Integer> totalNbPerType = new HashMap();

    public Object getStats(int statsIndex) {
        switch (STATISTICS.values()[statsIndex]) {
            case TOT_BTLES: {
                return this.totalNbBottles;
            }
            case TOT_TAKEN_BTLES: {
                return this.totalNbBottlesTaken;
            }
            case TOT_TO_DRINK: {
                return this.totalNbBottlesToDrink;
            }
            case QUANTITY: {
                return this.totalQuantity;
            }
            case TOT_PRICE: {
                return this.totalPrice;
            }
        }
        return null;
    }

    public String[] getCurrentStatsList() {
        return this.currentStatsList;
    }

    public void setCurrentStatsList(String[] currentStatsList) {
        this.currentStatsList = currentStatsList;
    }

    public int getTotalNbBottles() {
        return this.totalNbBottles;
    }

    public int getTotalNbBottlesTaken() {
        return this.totalNbBottlesTaken;
    }

    public int getTotalQuantity() {
        return this.totalQuantity;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public HashMap<String, Integer> getTotalNbPerCountries() {
        return this.totalNbPerCountries;
    }

    public HashMap<String, Integer> getTotalNbPerRegions() {
        return this.totalNbPerRegions;
    }

    public HashMap<String, Integer> getTotalNbPerType() {
        return this.totalNbPerType;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount() {
        return this.currentStatsList.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        for (int i = 0; i < statsList.length; ++i) {
            if (!this.currentStatsList[columnIndex].equals(statsList[i])) continue;
            return this.getStats(i);
        }
        return null;
    }

    @Override
    public String getColumnName(int i) {
        return this.currentStatsList[i];
    }

    public void updateStatistics(CopyOnWriteArrayList<CellarBottle> myCellar) {
        this.totalNbBottles = 0;
        this.totalNbBottlesTaken = 0;
        this.totalNbBottlesToDrink = 0;
        this.totalQuantity = 0;
        this.totalPrice = 0.0;
        for (int i = 0; i < myCellar.size(); ++i) {
            String curString;
            this.totalNbBottlesTaken += myCellar.get(i).getNbBtlesTaken();
            int curNbBtles = myCellar.get(i).getNbBtlesInStock();
            if (curNbBtles <= 0) continue;
            this.totalNbBottles += curNbBtles;
            this.totalQuantity += myCellar.get(i).getContenance() * curNbBtles;
            this.totalPrice += myCellar.get(i).getPrice() * (double)curNbBtles;
            if (myCellar.get(i).toDrink()) {
                this.totalNbBottlesToDrink += curNbBtles;
            }
            if (this.totalNbPerType.containsKey(curString = myCellar.get(i).getCountry())) {
                this.totalNbPerType.put(curString, this.totalNbPerType.get(curString) + curNbBtles);
            } else {
                this.totalNbPerType.put(curString, curNbBtles);
            }
            curString = myCellar.get(i).getRegion();
            if (this.totalNbPerType.containsKey(curString)) {
                this.totalNbPerType.put(curString, this.totalNbPerType.get(curString) + curNbBtles);
            } else {
                this.totalNbPerType.put(curString, curNbBtles);
            }
            curString = myCellar.get(i).getType();
            if (this.totalNbPerType.containsKey(curString)) {
                this.totalNbPerType.put(curString, this.totalNbPerType.get(curString) + curNbBtles);
                continue;
            }
            this.totalNbPerType.put(curString, curNbBtles);
        }
        this.fireTableDataChanged();
    }

    public void addBottles(int nbBottles, String country, String region, String type, boolean toDrink, int contenance, double price) {
        if (nbBottles > 0) {
            this.totalNbBottles += nbBottles;
            this.totalQuantity += contenance * nbBottles;
            this.totalPrice += price * (double)nbBottles;
            if (toDrink) {
                this.totalNbBottlesToDrink += nbBottles;
            }
            if (this.totalNbPerType.containsKey(country)) {
                this.totalNbPerType.put(country, this.totalNbPerType.get(country) + nbBottles);
            } else {
                this.totalNbPerType.put(country, nbBottles);
            }
            if (this.totalNbPerType.containsKey(region)) {
                this.totalNbPerType.put(region, this.totalNbPerType.get(region) + nbBottles);
            } else {
                this.totalNbPerType.put(region, nbBottles);
            }
            if (this.totalNbPerType.containsKey(type)) {
                this.totalNbPerType.put(type, this.totalNbPerType.get(type) + nbBottles);
            } else {
                this.totalNbPerType.put(type, nbBottles);
            }
            this.fireTableDataChanged();
        }
    }

    public void takeBottles(int nbBottles, String country, String region, String type, boolean toDrink, int contenance, double price) {
        if (nbBottles > 0) {
            int newNbBtles;
            this.totalNbBottles -= nbBottles;
            this.totalNbBottlesTaken += nbBottles;
            this.totalQuantity -= contenance * nbBottles;
            this.totalPrice -= price * (double)nbBottles;
            if (toDrink) {
                this.totalNbBottlesToDrink -= nbBottles;
            }
            if (this.totalNbPerType.containsKey(country)) {
                newNbBtles = this.totalNbPerType.get(country) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(country, newNbBtles);
                } else {
                    this.totalNbPerType.remove(country);
                }
            }
            if (this.totalNbPerType.containsKey(region)) {
                newNbBtles = this.totalNbPerType.get(region) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(region, newNbBtles);
                } else {
                    this.totalNbPerType.remove(region);
                }
            }
            if (this.totalNbPerType.containsKey(type)) {
                newNbBtles = this.totalNbPerType.get(type) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(type, newNbBtles);
                } else {
                    this.totalNbPerType.remove(type);
                }
            }
            this.fireTableDataChanged();
        }
    }

    public void removeBottles(int nbBottles, String country, String region, String type, boolean toDrink, int contenance, double price) {
        if (nbBottles > 0) {
            int newNbBtles;
            this.totalNbBottles -= nbBottles;
            this.totalQuantity -= contenance * nbBottles;
            this.totalPrice -= price * (double)nbBottles;
            if (toDrink) {
                this.totalNbBottlesToDrink -= nbBottles;
            }
            if (this.totalNbPerType.containsKey(country)) {
                newNbBtles = this.totalNbPerType.get(country) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(country, newNbBtles);
                } else {
                    this.totalNbPerType.remove(country);
                }
            }
            if (this.totalNbPerType.containsKey(region)) {
                newNbBtles = this.totalNbPerType.get(region) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(region, newNbBtles);
                } else {
                    this.totalNbPerType.remove(region);
                }
            }
            if (this.totalNbPerType.containsKey(type)) {
                newNbBtles = this.totalNbPerType.get(type) - nbBottles;
                if (newNbBtles > 0) {
                    this.totalNbPerType.put(type, newNbBtles);
                } else {
                    this.totalNbPerType.remove(type);
                }
            }
            this.fireTableDataChanged();
        }
    }

    public static enum STATISTICS {
        TOT_BTLES("# Bottles"),
        TOT_TAKEN_BTLES("# Taken"),
        TOT_TO_DRINK("# To Drink"),
        QUANTITY("Quantity"),
        TOT_PRICE("Total price");

        private final String statistic;

        private STATISTICS(String statistic) {
            this.statistic = statistic;
        }

        public String statistic() {
            return this.statistic;
        }

        static /* synthetic */ String access$000(STATISTICS x0) {
            return x0.statistic;
        }
    }
}

