/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.cellarmanager;

import ch.hearc.masict.jav.business.CellarBottle;
import ch.hearc.masict.jav.business.CellarModel;
import ch.hearc.masict.jav.business.InsufficientBottleException;
import ch.hearc.masict.jav.business.SimilarBottleException;
import ch.hearc.masict.jav.business.SpiritCellarBottle;
import ch.hearc.masict.jav.business.WineCellarBottle;
import ch.hearc.masict.jav.view.BottleAddedEvent;
import ch.hearc.masict.jav.view.BottleListener;
import ch.hearc.masict.jav.view.CellarBottleView;
import ch.hearc.masict.jav.view.ContenanceCellRenderer;
import ch.hearc.masict.jav.view.CurrencyCellRenderer;
import ch.hearc.masict.jav.view.LabelCellRenderer;
import ch.hearc.masict.jav.view.ListCellRenderer;
import ch.hearc.masict.jav.view.NameCellRenderer;
import ch.hearc.masict.jav.view.PercentCellRenderer;
import ch.hearc.masict.jav.view.RatingCellRenderer;
import ch.hearc.masict.jav.view.RowListFilter;
import ch.hearc.masict.jav.view.StringCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.io.FileUtils;

public class CellarManager
extends JFrame
implements ActionListener,
BottleListener,
ListSelectionListener {
    private static final int APP_WIDTH = 1280;
    private static final int APP_HEIGHT = 720;
    private static final int ROW_HEIGHT = 25;
    private static final int NAME_COL_WIDTH = 120;
    private static final int LIST_COL_WIDTH = 100;
    private static final int CONT_COL_WIDTH = 50;
    private static final int PERC_COL_WIDTH = 50;
    private static final int STOCK_COL_WIDTH = 20;
    private static final int APP_DIV = 640;
    private static final int DIV_WIDTH = 5;
    private static final double SPLIT_RATIO = 1.0;
    public static final int COMP_GAP = 10;
    public static final int TXT_GAP = 5;
    private static final String STR_SEARCH = "Search";
    private static final String STR_TOOL_SEARCH = "Search by keywords for: type, name, year, ... or by food, or even bottles to be drunk, ...";
    private JFileChooser databaseFileChooser;
    private File curDatDir = null;
    private Preferences cellarManagerPreferences;
    private JSplitPane jSplitMainFrame;
    private JPanel jPanelLeftFrame;
    private JPanel jPanelLeftTopFrame;
    private JPanel jPanelLeftTopContentFrame;
    private JPanel jPanelLeftBotFrame;
    private JPanel jPanelRightFrame;
    private JPanel jPanelRightTopFrame;
    private JPanel jPanelRightBotFrame;
    private JTextField jTxtSearch;
    private JButton jBtnClearSearch;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenuItem menuItemNew;
    private JMenuItem menuItemLoad;
    private JMenuItem menuItemSave;
    private JMenuItem menuItemSaveAs;
    private JMenuItem menuItemExit;
    private JMenuItem menuItemAddNewBtle;
    private JMenuItem menuItemAddBtle;
    private JMenuItem menuItemEditBtle;
    private JMenuItem menuItemTakeBtle;
    private JMenuItem menuItemRemoveBtle;
    private JMenuItem popMenuItemAddBtle;
    private JMenuItem popMenuItemEditBtle;
    private JMenuItem popMenuItemRemoveBtle;
    private JMenuItem popMenuItemTakeBtle;
    private ArrayList<JCheckBoxMenuItem> popMenuColumnChoice;
    private JTable jTableBtle;
    private JTable jTableStats;
    private JScrollPane jScrollTableBtle;
    private JScrollPane jScrollTableStats;
    private TableRowSorter<TableModel> tableBtleSorter;
    private JPopupMenu tablePopupMenu;
    private JPopupMenu tableHeaderPopupMenu;
    private CellarModel cellarDataModel = new CellarModel();
    private CellarBottleView bottleView;
    private AddNewBottleAction addNewBottleAction;
    private AddBottleAction addBottleAction;
    private TakeBottleAction takeBottleAction;
    private EditBottleAction editBottleAction;
    private RemoveBottleAction removeBottleAction;
    private ColumnMenuListener columnMenuListener;
    private boolean databaseModified;

    private CellarManager() {
        super("Cellar Manager");
        this.initComponents();
    }

    public CellarManager(String myTitre) {
        super(myTitre);
        this.initComponents();
    }

    private void initComponents() {
        this.cellarManagerPreferences = Preferences.userNodeForPackage(this.getClass());
        String curDirPath = this.cellarManagerPreferences.get(PREFERENCES.DATABASE_PATH.prefs, "");
        if (!curDirPath.isEmpty()) {
            this.curDatDir = new File(curDirPath);
            File datFile = new File(this.curDatDir.getAbsolutePath() + "\\" + this.curDatDir.getName() + ".dat");
            if (this.curDatDir.exists()) {
                try {
                    this.cellarDataModel.loadCellar(datFile);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this, "Database not found. Cellar not loaded.", "Cellar database not found", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error loading database. Please retry or contact administrator.", "Cellar database loading error", 0);
                }
                catch (ClassNotFoundException ex) {
                    JOptionPane.showMessageDialog(this, "Invalid database file. Cellar not loaded.", "Invalid cellar database file", 0);
                }
            }
        }
        this.databaseModified = false;
        this.menuFile = new JMenu("File");
        this.menuFile.setMnemonic('F');
        this.menuItemNew = new JMenuItem("New Database");
        this.menuItemNew.addActionListener(this);
        this.menuItemNew.setMnemonic('N');
        this.menuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.menuFile.add(this.menuItemNew);
        this.menuItemLoad = new JMenuItem("Load Database...");
        this.menuItemLoad.addActionListener(this);
        this.menuItemLoad.setMnemonic('L');
        this.menuItemLoad.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.menuFile.add(this.menuItemLoad);
        this.menuItemSave = new JMenuItem("Save Database");
        this.menuItemSave.addActionListener(this);
        this.menuItemSave.setMnemonic('S');
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFile.add(this.menuItemSave);
        this.menuItemSaveAs = new JMenuItem("Save Database As...");
        this.menuItemSaveAs.addActionListener(this);
        this.menuItemSaveAs.setMnemonic('A');
        this.menuFile.add(this.menuItemSaveAs);
        this.menuItemExit = new JMenuItem("Exit");
        this.menuItemExit.addActionListener(this);
        this.menuItemExit.setMnemonic('X');
        this.menuItemExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.menuFile.add(this.menuItemExit);
        this.menuEdit = new JMenu("Edit");
        this.menuEdit.setMnemonic('E');
        this.addNewBottleAction = new AddNewBottleAction();
        this.menuItemAddNewBtle = new JMenuItem(this.addNewBottleAction);
        this.menuItemAddNewBtle.setMnemonic('B');
        this.menuItemAddNewBtle.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.menuEdit.add(this.menuItemAddNewBtle);
        this.addBottleAction = new AddBottleAction();
        this.menuItemAddBtle = new JMenuItem(this.addBottleAction);
        this.menuItemAddBtle.setMnemonic('A');
        this.menuItemAddBtle.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.menuEdit.add(this.menuItemAddBtle);
        this.editBottleAction = new EditBottleAction();
        this.menuItemEditBtle = new JMenuItem(this.editBottleAction);
        this.menuItemEditBtle.setMnemonic('E');
        this.menuItemEditBtle.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.menuEdit.add(this.menuItemEditBtle);
        this.takeBottleAction = new TakeBottleAction();
        this.menuItemTakeBtle = new JMenuItem(this.takeBottleAction);
        this.menuItemTakeBtle.setMnemonic('T');
        this.menuItemTakeBtle.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.menuEdit.add(this.menuItemTakeBtle);
        this.removeBottleAction = new RemoveBottleAction();
        this.menuItemRemoveBtle = new JMenuItem(this.removeBottleAction);
        this.menuItemRemoveBtle.setMnemonic('R');
        this.menuEdit.add(this.menuItemRemoveBtle);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuEdit);
        this.setJMenuBar(this.menuBar);
        this.databaseFileChooser = new JFileChooser();
        this.databaseFileChooser.setFileSelectionMode(1);
        this.jTxtSearch = new JTextField(STR_SEARCH);
        this.jTxtSearch.addActionListener(new SearchListener());
        this.jTxtSearch.addMouseListener(new SearchMouseListener());
        this.jTxtSearch.setToolTipText(STR_TOOL_SEARCH);
        this.jTxtSearch.setBorder(null);
        this.jBtnClearSearch = new JButton("X");
        this.jBtnClearSearch.addActionListener(this);
        this.jBtnClearSearch.setOpaque(true);
        this.jBtnClearSearch.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jBtnClearSearch.setBackground(Color.white);
        this.jPanelLeftTopContentFrame = new JPanel(new BorderLayout());
        this.jPanelLeftTopContentFrame.add((Component)this.jTxtSearch, "Center");
        this.jPanelLeftTopContentFrame.add((Component)this.jBtnClearSearch, "East");
        this.jPanelLeftTopContentFrame.setBorder(BorderFactory.createEtchedBorder(1));
        this.jPanelLeftTopFrame = new JPanel(new BorderLayout());
        this.jPanelLeftTopFrame.add((Component)this.jPanelLeftTopContentFrame, "Center");
        this.jPanelLeftTopFrame.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.popMenuItemAddBtle = new JMenuItem(this.addBottleAction);
        this.popMenuItemAddBtle.setMnemonic('A');
        this.popMenuItemAddBtle.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.popMenuItemEditBtle = new JMenuItem(this.editBottleAction);
        this.popMenuItemEditBtle.setMnemonic('E');
        this.popMenuItemEditBtle.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.popMenuItemTakeBtle = new JMenuItem(this.takeBottleAction);
        this.popMenuItemTakeBtle.setMnemonic('T');
        this.popMenuItemTakeBtle.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.popMenuItemRemoveBtle = new JMenuItem(this.removeBottleAction);
        this.popMenuItemRemoveBtle.setMnemonic('R');
        this.tablePopupMenu = new JPopupMenu();
        this.tablePopupMenu.add(this.popMenuItemAddBtle);
        this.tablePopupMenu.add(this.popMenuItemEditBtle);
        this.tablePopupMenu.add(this.popMenuItemTakeBtle);
        this.tablePopupMenu.add(this.popMenuItemRemoveBtle);
        this.tableHeaderPopupMenu = new JPopupMenu();
        this.popMenuColumnChoice = new ArrayList();
        this.columnMenuListener = new ColumnMenuListener();
        for (int i = 0; i < CellarBottle.allAttributeList.length; ++i) {
            JCheckBoxMenuItem newAttributeMenuSelect = new JCheckBoxMenuItem(CellarBottle.allAttributeList[i]);
            for (int j = 0; j < CellarBottle.defaultAttributeList.length; ++j) {
                if (!CellarBottle.allAttributeList[i].equals(CellarBottle.defaultAttributeList[j])) continue;
                newAttributeMenuSelect.setSelected(true);
                break;
            }
            newAttributeMenuSelect.addActionListener(this.columnMenuListener);
            this.popMenuColumnChoice.add(newAttributeMenuSelect);
            this.tableHeaderPopupMenu.add(this.popMenuColumnChoice.get(i));
        }
        this.jTableBtle = new JTable(this.cellarDataModel);
        this.jTableBtle.setAutoCreateColumnsFromModel(true);
        this.jTableBtle.getSelectionModel().addListSelectionListener(this);
        this.jTableBtle.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.jTableBtle.setDefaultRenderer(String.class, new StringCellRenderer());
        this.jTableBtle.setSelectionMode(0);
        this.jTableBtle.setComponentPopupMenu(this.tablePopupMenu);
        this.jTableBtle.getTableHeader().setComponentPopupMenu(this.tableHeaderPopupMenu);
        this.jTableBtle.addMouseListener(new TableMouseListener());
        this.tableBtleSorter = new TableRowSorter<TableModel>(this.jTableBtle.getModel());
        this.tableBtleSorter.setSortsOnUpdates(true);
        int dblLine = 2 * this.jTableBtle.getFontMetrics(this.jTableBtle.getFont()).getHeight() + 4;
        this.jTableBtle.setRowHeight(dblLine);
        List<String> attribList = Arrays.asList(CellarBottle.defaultAttributeList);
        this.SetTableColumns(attribList);
        this.jTableBtle.setRowSorter(this.tableBtleSorter);
        this.jScrollTableBtle = new JScrollPane(this.jTableBtle);
        this.jScrollTableBtle.addMouseListener(new ScrollPaneMouseListener());
        this.jPanelLeftBotFrame = new JPanel(new BorderLayout(10, 10), true);
        this.jPanelLeftBotFrame.setBorder(BorderFactory.createTitledBorder("Cellar Bottles"));
        this.jPanelLeftBotFrame.add((Component)this.jScrollTableBtle, "Center");
        this.jPanelLeftFrame = new JPanel(new BorderLayout(), true);
        this.jPanelLeftFrame.add((Component)this.jPanelLeftTopFrame, "North");
        this.jPanelLeftFrame.add((Component)this.jPanelLeftBotFrame, "Center");
        this.jTableStats = new JTable(this.cellarDataModel.getMyCellarStats());
        this.jTableStats.setSelectionMode(0);
        this.jPanelRightTopFrame = new JPanel(new BorderLayout(10, 10), true);
        this.jPanelRightTopFrame.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.jPanelRightTopFrame.add((Component)this.jTableStats.getTableHeader(), "North");
        this.jPanelRightTopFrame.add((Component)this.jTableStats, "Center");
        this.jPanelRightBotFrame = new JPanel(new BorderLayout(0, 0), true);
        this.jPanelRightBotFrame.setBorder(BorderFactory.createTitledBorder("Selected Bottle Information"));
        if (this.curDatDir == null) {
            this.curDatDir = new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString());
        }
        this.bottleView = new CellarBottleView(this.jPanelRightBotFrame, this.curDatDir.getAbsolutePath());
        this.bottleView.addBottleListener(this);
        this.jPanelRightFrame = new JPanel(new BorderLayout(10, 10), true);
        this.jPanelRightFrame.add((Component)this.jPanelRightTopFrame, "North");
        this.jPanelRightFrame.add((Component)this.jPanelRightBotFrame, "Center");
        this.jSplitMainFrame = new JSplitPane(1, true, this.jPanelLeftFrame, this.jPanelRightFrame);
        this.add(this.jSplitMainFrame);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.setSize(1280, 720);
        this.jSplitMainFrame.setDividerLocation(640);
    }

    public static void main(String[] args) {
        new WineCellarBottle();
        new SpiritCellarBottle();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CellarManager myCellarManager = new CellarManager();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.menuItemNew) {
            int answer = 0;
            if (this.databaseModified) {
                answer = JOptionPane.showOptionDialog(null, "Create new database : all unsaved data will be lost. Continue ?", "New Database", 2, 3, null, null, null);
            }
            if (answer == 0) {
                this.cellarDataModel.clearCellar();
                this.databaseModified = false;
                this.curDatDir = new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString());
                this.bottleView.setDatabasePath(this.curDatDir.getAbsolutePath());
                this.SetTableColumns(this.cellarDataModel.getCurrentAttributeList());
                this.bottleView.bottleChanged(null);
            }
            return;
        }
        if (src == this.menuItemLoad) {
            int answer = 0;
            if (this.databaseModified) {
                answer = JOptionPane.showOptionDialog(null, "Open database : all unsaved data will be lost. Continue ?", "Open Database", 2, 3, null, null, null);
            }
            if (answer == 0) {
                File dataDir;
                File dataFile;
                this.databaseFileChooser.setDialogTitle("Load Database...");
                int returnVal = this.databaseFileChooser.showOpenDialog(this.menuItemLoad);
                if (returnVal == 0 && (dataFile = new File((dataDir = this.databaseFileChooser.getSelectedFile()).getAbsoluteFile() + "\\" + dataDir.getName() + ".dat")).exists()) {
                    try {
                        this.cellarDataModel.loadCellar(dataFile);
                        this.databaseModified = false;
                        this.curDatDir = dataDir;
                        this.cellarManagerPreferences.put(PREFERENCES.DATABASE_PATH.prefs, this.curDatDir.getCanonicalPath());
                        if (this.curDatDir == null) {
                            this.curDatDir = new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString());
                        }
                        this.bottleView.setDatabasePath(this.curDatDir.getAbsolutePath());
                        this.SetTableColumns(this.cellarDataModel.getCurrentAttributeList());
                        this.bottleView.bottleChanged(null);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(this.menuItemLoad, "Database file not found. Cellar not loaded.", "Cellar database not found", 0);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(this.menuItemLoad, "Error loading database file. Please retry or contact administrator.", "Cellar database loading error", 0);
                    }
                    catch (ClassNotFoundException ex) {
                        JOptionPane.showMessageDialog(this.menuItemLoad, "Invalid database file. Cellar not loaded.", "Invalid cellar database file", 0);
                    }
                }
            }
            return;
        }
        if (src == this.menuItemSave) {
            this.saveDatabase(false);
            return;
        }
        if (src == this.menuItemSaveAs) {
            this.saveDatabase(true);
            return;
        }
        if (src == this.jBtnClearSearch) {
            this.jTxtSearch.setText("");
            this.tableBtleSorter.setRowFilter(RowFilter.regexFilter(this.jTxtSearch.getText(), new int[0]));
            this.jTxtSearch.requestFocus();
            return;
        }
        if (src == this.menuItemExit) {
            int answer = 1;
            if (this.databaseModified) {
                answer = JOptionPane.showOptionDialog(null, "Database modified: Do you want to save modification ?", "Database odified", 1, 3, null, null, null);
            }
            if (answer == 2) {
                return;
            }
            if (answer == 0) {
                this.saveDatabase(false);
            }
            System.exit(0);
        }
        throw new UnsupportedOperationException("Action is not supported yet.");
    }

    public void saveDatabase(boolean forceChoose) {
        if (this.curDatDir.equals(new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString())) || forceChoose) {
            this.databaseFileChooser.setDialogTitle("Save Database As...");
            int returnVal = this.databaseFileChooser.showSaveDialog(this.menuItemSaveAs);
            if (returnVal == 0) {
                int answer;
                File dataDir = this.databaseFileChooser.getSelectedFile();
                File dataFile = new File(dataDir.getAbsoluteFile() + "\\" + dataDir.getName() + ".dat");
                if (dataFile.exists() && (answer = JOptionPane.showOptionDialog(null, "File already exist, overwrite ?", "Cellar database already exists", 2, 3, null, null, null)) != 0) {
                    return;
                }
                try {
                    if (!dataDir.exists()) {
                        dataDir.mkdir();
                    }
                    this.cellarDataModel.saveCellar(dataFile);
                    this.databaseModified = false;
                    FileUtils.moveDirectory(new File(this.curDatDir.getAbsoluteFile() + "\\ImageFolder\\"), new File(dataDir + "\\ImageFolder\\"));
                    this.curDatDir = dataDir;
                    this.cellarManagerPreferences.put(PREFERENCES.DATABASE_PATH.prefs, this.curDatDir.getAbsolutePath());
                    if (this.curDatDir == null) {
                        this.curDatDir = new File(new JFileChooser().getFileSystemView().getDefaultDirectory().toString());
                    }
                    this.bottleView.setDatabasePath(this.curDatDir.getAbsolutePath());
                    this.SetTableColumns(this.cellarDataModel.getCurrentAttributeList());
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this.menuItemLoad, "Database files not found. Cellar not saved.", "Cellar database not found", 0);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(this.menuItemLoad, "Error saving database files. Please retry or contact administrator.", "Cellar database saving error", 0);
                }
            }
        } else {
            try {
                File dataFile = new File(this.curDatDir.getAbsoluteFile() + "\\" + this.curDatDir.getName() + ".dat");
                this.cellarDataModel.saveCellar(dataFile);
                this.databaseModified = false;
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.menuItemLoad, "Database file not found. Cellar not saved.", "Cellar database not found", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.menuItemLoad, "Error saving database file. Please retry or contact administrator.", "Cellar database saving error", 0);
            }
        }
    }

    @Override
    public void bottleAdded(BottleAddedEvent event) {
        ArrayList<CellarBottle> bottleList = this.cellarDataModel.getSimilarBottles(event.getBottle());
        if (bottleList.size() > 0) {
            JDialog questionFrame = new JDialog(this, "Similar Bottles found.", true);
            JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
            JComboBox<String> similarList = new JComboBox<String>();
            for (int i = 0; i < bottleList.size(); ++i) {
                similarList.addItem(bottleList.get(i).getName());
            }
            JPanel topPanel = new JPanel();
            topPanel.add(similarList);
            mainPanel.add((Component)topPanel, "North");
            JPanel middlePanel = new JPanel();
            mainPanel.add((Component)middlePanel, "Center");
            JButton buttonOK = new JButton("Add anyway");
            JButton buttonCancel = new JButton("Cancel");
            JPanel botPanel = new JPanel(new FlowLayout(2));
            botPanel.add(buttonOK);
            botPanel.add(buttonCancel);
            mainPanel.add((Component)botPanel, "South");
            CellarBottleView bottleView = new CellarBottleView(middlePanel, bottleList.get(0));
            questionFrame.add(mainPanel);
            questionFrame.setVisible(true);
            this.cellarDataModel.addBottleForce(event.getBottle());
        }
        try {
            this.cellarDataModel.addBottle(event.getBottle());
            this.databaseModified = true;
        }
        catch (SimilarBottleException ex) {
            JOptionPane.showMessageDialog(null, "Similar bottle exist. Bottle not added", "Similar bottle found", 0);
        }
    }

    @Override
    public void bottleChanged(BottleAddedEvent event) {
        int[] selection = this.jTableBtle.getSelectedRows();
        if (selection.length > 0) {
            int newIndex = this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0]);
            this.cellarDataModel.setRowBottle(event.getBottle(), newIndex);
            this.cellarDataModel.fireTableRowsUpdated(newIndex, newIndex);
            this.databaseModified = true;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int[] selection;
            if (e.getSource() == this.jTableBtle.getColumnModel().getSelectionModel()) {
                this.jTableBtle.editingCanceled(null);
            }
            if ((selection = this.jTableBtle.getSelectedRows()).length > 0) {
                int newIndex = this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0]);
                this.bottleView.setEdit(CellarBottleView.ViewMode.VIEW);
                this.bottleView.bottleChanged(this.cellarDataModel.getRowBottle(newIndex));
            }
        }
    }

    private void SetTableColumns(List<String> attribList) {
        for (int i = 0; i < attribList.size(); ++i) {
            if (CellarBottle.attributeToType(attribList.get(i)).equals((Object)CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH)) {
                if (this.curDatDir != null) {
                    this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new LabelCellRenderer(this.curDatDir.getAbsolutePath()));
                } else {
                    this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new LabelCellRenderer(new JFileChooser().getFileSystemView().getDefaultDirectory().toString()));
                }
                this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(this.jTableBtle.getRowHeight() + 4);
                this.tableBtleSorter.setSortable(i, false);
            }
            if (attribList.get(i).equals(CellarBottle.ATTRIBUTES.NAME.attribute())) {
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new NameCellRenderer());
                this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(120);
            }
            if (CellarBottle.attributeToType(attribList.get(i)).equals((Object)CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST)) {
                ListCellRenderer listCell = new ListCellRenderer();
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(listCell);
                this.jTableBtle.getColumnModel().getColumn(i).setCellEditor(listCell);
                this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(100);
            }
            if (attribList.get(i).equals(CellarBottle.ATTRIBUTES.CONTENANCE.attribute())) {
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new ContenanceCellRenderer());
                this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(50);
            }
            if (CellarBottle.attributeToType(attribList.get(i)).equals((Object)CellarBottle.ATTRIBUTE_TYPES.VALUE_PERCENT)) {
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new PercentCellRenderer());
                this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(50);
            }
            if (CellarBottle.attributeToType(attribList.get(i)).equals((Object)CellarBottle.ATTRIBUTE_TYPES.VALUE_MONEY)) {
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new CurrencyCellRenderer());
            }
            if (CellarBottle.attributeToType(attribList.get(i)).equals((Object)CellarBottle.ATTRIBUTE_TYPES.RATE)) {
                this.jTableBtle.getColumnModel().getColumn(i).setCellRenderer(new RatingCellRenderer());
            }
            if (!attribList.get(i).equals(CellarBottle.ATTRIBUTES.BOTTLE_NB_STOCK.attribute())) continue;
            this.jTableBtle.getColumnModel().getColumn(i).setPreferredWidth(20);
        }
    }

    private class ScrollPaneMouseListener
    extends MouseAdapter {
        private ScrollPaneMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                JMenuItem menuPopItemAddNewBtle = new JMenuItem(CellarManager.this.addNewBottleAction);
                JPopupMenu popup = new JPopupMenu();
                popup.add(menuPopItemAddNewBtle);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int r = CellarManager.this.jTableBtle.rowAtPoint(e.getPoint());
            int c = CellarManager.this.jTableBtle.columnAtPoint(e.getPoint());
            if (r >= 0 && r < CellarManager.this.jTableBtle.getRowCount()) {
                CellarManager.this.jTableBtle.setRowSelectionInterval(r, r);
            } else {
                CellarManager.this.jTableBtle.clearSelection();
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    JMenuItem menuPopItemAddNewBtle = new JMenuItem(CellarManager.this.addNewBottleAction);
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(menuPopItemAddNewBtle);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    private class SearchMouseListener
    extends MouseAdapter {
        private SearchMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (CellarManager.STR_SEARCH.equals(CellarManager.this.jTxtSearch.getText())) {
                CellarManager.this.jTxtSearch.setText("");
            }
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                ArrayList filters = new ArrayList();
                RowFilter stringFilter = RowFilter.regexFilter("(?i)" + CellarManager.this.jTxtSearch.getText(), new int[0]);
                filters.add(stringFilter);
                RowListFilter listFilter = new RowListFilter("(?i)" + CellarManager.this.jTxtSearch.getText());
                filters.add(listFilter);
                RowFilter compoundRowFilter = RowFilter.orFilter(filters);
                CellarManager.this.tableBtleSorter.setRowFilter(compoundRowFilter);
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(CellarManager.this.jTxtSearch, "Invalid search pattern.", "Search pattern error", 0);
                System.err.println("Bad regex pattern");
            }
        }
    }

    private class ColumnMenuListener
    implements ActionListener {
        private ColumnMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ArrayList<String> newColumnList = new ArrayList<String>();
            for (int i = 0; i < CellarManager.this.popMenuColumnChoice.size(); ++i) {
                if (!((JCheckBoxMenuItem)CellarManager.this.popMenuColumnChoice.get(i)).isSelected()) continue;
                newColumnList.add(((JCheckBoxMenuItem)CellarManager.this.popMenuColumnChoice.get(i)).getText());
            }
            CellarManager.this.cellarDataModel.setCurrentAttributeList(newColumnList);
            CellarManager.this.SetTableColumns(CellarManager.this.cellarDataModel.getCurrentAttributeList());
            CellarManager.this.jTableBtle.getTableHeader().setDraggedColumn(null);
        }
    }

    private class RemoveBottleAction
    extends AbstractAction {
        private RemoveBottleAction() {
            super("Remove Selected Bottle");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selection = CellarManager.this.jTableBtle.getSelectedRows();
            int[] modelIndex = new int[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                modelIndex[i] = CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[i]);
            }
            Arrays.sort(modelIndex);
            if (selection.length > 0) {
                int answer = JOptionPane.showOptionDialog(null, "Remove bottles : do you really want to remove selected bottle(s) ?", "Remove Bottle(s)", 2, 3, null, null, null);
                if (answer == 0) {
                    for (int i = selection.length - 1; i >= 0; --i) {
                        int j;
                        for (j = 0; j < CellarBottle.modifAttributeList.length; ++j) {
                            String imgPath;
                            File imgFile;
                            CellarBottle.ATTRIBUTE_TYPES attribType;
                            int attributeIndex = CellarBottle.attributeToIndex(CellarBottle.modifAttributeList[j]);
                            if (attributeIndex < 0 || (attribType = CellarBottle.allAttributeTypeList[attributeIndex]) != CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH || !(imgFile = new File(imgPath = CellarManager.this.curDatDir.getAbsolutePath() + (String)CellarManager.this.cellarDataModel.getRowBottle(modelIndex[i]).getAttribute(attributeIndex))).exists()) continue;
                            imgFile.delete();
                        }
                        for (j = 0; j < CellarManager.this.cellarDataModel.getRowBottle(modelIndex[i]).getExtraAttributeList().length; ++j) {
                            String imgPath;
                            File imgFile;
                            CellarBottle.ATTRIBUTE_TYPES attribType = CellarManager.this.cellarDataModel.getRowBottle(modelIndex[i]).getExtraAttributeTypeList()[i];
                            if (attribType != CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH || !(imgFile = new File(imgPath = CellarManager.this.curDatDir.getAbsolutePath() + (String)CellarManager.this.cellarDataModel.getRowBottle(modelIndex[i]).getExtraAttribute(i))).exists() || !imgFile.exists()) continue;
                            imgFile.delete();
                        }
                        CellarManager.this.cellarDataModel.removeBottle(modelIndex[i]);
                        CellarManager.this.databaseModified = true;
                    }
                }
                if ((selection = CellarManager.this.jTableBtle.getSelectedRows()).length > 0) {
                    CellarManager.this.bottleView.bottleChanged(CellarManager.this.cellarDataModel.getRowBottle(CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0])));
                } else {
                    CellarManager.this.bottleView.bottleChanged(null);
                }
            }
        }
    }

    private class TakeBottleAction
    extends AbstractAction {
        private TakeBottleAction() {
            super("Take Bottle(s)...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selection = CellarManager.this.jTableBtle.getSelectedRows();
            int[] modelIndex = new int[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                modelIndex[i] = CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[i]);
            }
            if (selection.length > 0) {
                String nbBottles = (String)JOptionPane.showInputDialog(CellarManager.this.menuItemTakeBtle, "Take bottles: how many bottles do you want to take from selected rows of your cellar ?", "Take bottle(s)", 3, null, null, "1");
                if (nbBottles != null && nbBottles.length() > 0) {
                    for (int i = selection.length - 1; i >= 0; --i) {
                        try {
                            CellarManager.this.cellarDataModel.takeBottle(modelIndex[i], Integer.parseInt(nbBottles));
                            CellarManager.this.databaseModified = true;
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(CellarManager.this.menuItemTakeBtle, "Invalid number of bottles.", "Number of bottles error", 0);
                            continue;
                        }
                        catch (InsufficientBottleException ex) {
                            JOptionPane.showMessageDialog(CellarManager.this.menuItemTakeBtle, "Not enough bottles to take " + ex.getNbBtlesToRemove() + ".", "Not enough bottles error", 0);
                        }
                    }
                }
                if ((selection = CellarManager.this.jTableBtle.getSelectedRows()).length > 0) {
                    CellarManager.this.bottleView.bottleChanged(CellarManager.this.cellarDataModel.getRowBottle(CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0])));
                } else {
                    CellarManager.this.bottleView.bottleChanged(null);
                }
            }
        }
    }

    private class EditBottleAction
    extends AbstractAction {
        private EditBottleAction() {
            super("Edit Selected Bottle");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selection = CellarManager.this.jTableBtle.getSelectedRows();
            if (selection.length > 0) {
                CellarManager.this.bottleView.setEdit(CellarBottleView.ViewMode.EDIT);
                CellarManager.this.bottleView.bottleChanged(CellarManager.this.cellarDataModel.getRowBottle(CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0])));
                CellarManager.this.jTableBtle.setRowSelectionInterval(selection[0], selection[0]);
            }
        }
    }

    private class AddBottleAction
    extends AbstractAction {
        private AddBottleAction() {
            super("Add Bottle(s)...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selection = CellarManager.this.jTableBtle.getSelectedRows();
            int[] modelIndex = new int[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                modelIndex[i] = CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[i]);
            }
            if (selection.length > 0) {
                String nbBottles = (String)JOptionPane.showInputDialog(CellarManager.this.menuItemAddBtle, "Add bottles: how many bottles do you want to add to selected rows of your cellar ?", "Add bottle(s)", 3, null, null, "1");
                if (nbBottles != null && nbBottles.length() > 0) {
                    for (int i = selection.length - 1; i >= 0; --i) {
                        try {
                            CellarManager.this.cellarDataModel.addBottle(modelIndex[i], Integer.parseInt(nbBottles));
                            CellarManager.this.databaseModified = true;
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(CellarManager.this.menuItemAddBtle, "Invalid number of bottles.", "Number of bottles error", 0);
                        }
                    }
                }
                if ((selection = CellarManager.this.jTableBtle.getSelectedRows()).length > 0) {
                    CellarManager.this.bottleView.bottleChanged(CellarManager.this.cellarDataModel.getRowBottle(CellarManager.this.jTableBtle.getRowSorter().convertRowIndexToModel(selection[0])));
                } else {
                    CellarManager.this.bottleView.bottleChanged(null);
                }
            }
        }
    }

    private class AddNewBottleAction
    extends AbstractAction {
        private AddNewBottleAction() {
            super("Add New Bottle");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellarManager.this.bottleView.setEdit(CellarBottleView.ViewMode.ADD);
        }
    }

    public static enum PREFERENCES {
        DATABASE_PATH("Database Path");

        private final String prefs;

        private PREFERENCES(String prefs) {
            this.prefs = prefs;
        }

        public String prefs() {
            return this.prefs;
        }
    }
}

