/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import ch.hearc.masict.jav.business.CellarBottle;
import ch.hearc.masict.jav.business.SpiritCellarBottle;
import ch.hearc.masict.jav.business.WineCellarBottle;
import ch.hearc.masict.jav.view.BottleAddedEvent;
import ch.hearc.masict.jav.view.BottleListener;
import ch.hearc.masict.jav.view.ImagePanel;
import ch.hearc.masict.jav.view.RatingLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class CellarBottleView
implements ActionListener,
PropertyChangeListener,
FocusListener {
    private CellarBottle curBottle = null;
    private CellarBottle oldBottle = null;
    private String databasePath;
    private JPanel jPanelBottleView = null;
    private JPanel jPanelBottleViewTop;
    private JPanel jPanelBottleViewAttributes;
    private JPanel jPanelStringAttributesView;
    private JPanel jPanelBottleViewBottom;
    private JPanel jPanelImageAttributesView;
    private JPanel jPanelValueAttributesView;
    private ArrayList<JLabel> stringAttributesLabels;
    private ArrayList<JLabel> valueAttributesLabels;
    private ArrayList<JLabel> stringExtraAttributesLabels;
    private ArrayList<JLabel> valueExtraAttributesLabels;
    private ArrayList<JLabel> dropAttributesLabels;
    private ArrayList<JLabel> dropExtraAttributesLabels;
    private ArrayList<JLabel> boolAttributesLabels;
    private ArrayList<JLabel> boolExtraAttributesLabels;
    private ArrayList<JLabel> rateAttributesLabels;
    private ArrayList<JLabel> rateExtraAttributesLabels;
    private ArrayList<JTextArea> textAttributes;
    private ArrayList<JTextArea> textExtraAttributes;
    private ArrayList<JFormattedTextField> valueAttributes;
    private ArrayList<JFormattedTextField> valueExtraAttributes;
    private ArrayList<JComboBox> dropAttributes;
    private ArrayList<JComboBox> dropExtraAttributes;
    private ArrayList<JCheckBox> boolAttributes;
    private ArrayList<JCheckBox> boolExtraAttributes;
    private ArrayList<RatingLabel> rateAttributes;
    private ArrayList<RatingLabel> rateExtraAttributes;
    private ArrayList<String> imageList;
    private ArrayList<String> extraImageList;
    private JLabel jLabelBottleType;
    private JComboBox jComboBottleType;
    private JComboBox jComboBottleAttributesImage;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private ImagePanel imageViewer;
    private ArrayList<BufferedImage> imageArray;
    private ArrayList<BufferedImage> extraImageArray;
    private ViewMode edit;
    private EventListenerList listeners;

    public CellarBottleView() {
        this.edit = ViewMode.VIEW;
        this.databasePath = "";
        this.initComponents();
        this.updateBottleView();
    }

    public CellarBottleView(JPanel jPanelBottleView) {
        this.jPanelBottleView = jPanelBottleView;
        this.edit = ViewMode.VIEW;
        this.databasePath = "";
        this.initComponents();
        this.buildGeneralView();
        this.updateBottleView();
    }

    public CellarBottleView(JPanel jPanelBottleView, CellarBottle curBottle) {
        this.jPanelBottleView = jPanelBottleView;
        this.curBottle = curBottle;
        this.edit = ViewMode.VIEW;
        this.databasePath = "";
        this.initComponents();
        this.buildGeneralView();
        this.buildExtraAttributComponents();
        this.updateBottleFields();
        this.updateBottleView();
        this.buildBottleView();
    }

    public CellarBottleView(JPanel jPanelBottleView, String databasePath) {
        this.jPanelBottleView = jPanelBottleView;
        this.edit = ViewMode.VIEW;
        this.databasePath = databasePath;
        File imageDir = new File(databasePath + "\\ImageFolder\\");
        if (!imageDir.exists()) {
            imageDir.mkdir();
        }
        this.initComponents();
        this.buildGeneralView();
        this.updateBottleView();
    }

    public CellarBottleView(JPanel jPanelBottleView, CellarBottle curBottle, String databasePath) {
        this.jPanelBottleView = jPanelBottleView;
        this.curBottle = curBottle;
        this.edit = ViewMode.VIEW;
        this.databasePath = databasePath;
        File imageDir = new File(databasePath + "\\ImageFolder\\");
        if (!imageDir.exists()) {
            imageDir.mkdir();
        }
        this.initComponents();
        this.buildGeneralView();
        this.buildExtraAttributComponents();
        this.updateBottleFields();
        this.updateBottleView();
        this.buildBottleView();
    }

    private void initComponents() {
        this.listeners = new EventListenerList();
        this.jLabelBottleType = new JLabel("Bottle Type:");
        this.jComboBottleType = new JComboBox<String>(CellarBottle.subClassList.toArray(new String[0]));
        this.jComboBottleType.setEditable(false);
        this.jComboBottleType.addActionListener(this);
        this.jPanelBottleViewTop = new JPanel(new FlowLayout(0, 10, 10), true);
        this.jPanelBottleViewTop.add(this.jLabelBottleType);
        this.jPanelBottleViewTop.add(this.jComboBottleType);
        this.jButtonCancel = new JButton("Discard");
        this.jButtonCancel.addActionListener(this);
        this.jButtonOK = new JButton();
        this.jButtonOK.addActionListener(this);
        this.jPanelBottleViewBottom = new JPanel(new FlowLayout(2, 10, 10), true);
        this.jPanelBottleViewBottom.add(this.jButtonCancel);
        this.jPanelBottleViewBottom.add(this.jButtonOK);
        this.jPanelValueAttributesView = new JPanel();
        this.jPanelStringAttributesView = new JPanel();
        this.jPanelImageAttributesView = new JPanel(new BorderLayout(10, 10), true);
        this.jPanelBottleViewAttributes = new JPanel(new BorderLayout(10, 10), true);
        this.jPanelBottleViewAttributes.add((Component)this.jPanelStringAttributesView, "West");
        this.jPanelBottleViewAttributes.add((Component)this.jPanelImageAttributesView, "Center");
        this.jPanelBottleViewAttributes.add((Component)this.jPanelValueAttributesView, "South");
        this.buildAttributComponents();
    }

    public void setjPanelBottleView(JPanel panelBottleView) {
        this.jPanelBottleView = panelBottleView;
        this.buildGeneralView();
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
        File imageDir = new File(databasePath + "\\ImageFolder\\");
        if (!imageDir.exists()) {
            imageDir.mkdir();
        }
    }

    public void setEdit(ViewMode edit) {
        if (edit.equals((Object)ViewMode.EDIT) && !this.edit.equals((Object)ViewMode.EDIT)) {
            this.oldBottle = this.curBottle;
        }
        if (edit.equals((Object)ViewMode.ADD) && !this.edit.equals((Object)ViewMode.ADD)) {
            this.oldBottle = this.curBottle;
            if ("WineCellarBottle".equalsIgnoreCase((String)this.jComboBottleType.getSelectedItem())) {
                this.bottleChanged(new WineCellarBottle());
            } else if ("SpiritCellarBottle".equalsIgnoreCase((String)this.jComboBottleType.getSelectedItem())) {
                this.bottleChanged(new SpiritCellarBottle());
            }
        }
        this.edit = edit;
        this.updateBottleView();
    }

    private void buildGeneralView() {
        if (this.jPanelBottleView != null) {
            this.jPanelBottleView.removeAll();
            this.jPanelBottleView.setLayout(new BorderLayout(10, 10));
            this.jPanelBottleView.setDoubleBuffered(true);
            this.jPanelBottleView.add((Component)this.jPanelBottleViewTop, "North");
            this.jPanelBottleView.add((Component)this.jPanelBottleViewBottom, "South");
            this.jPanelBottleView.add((Component)this.jPanelBottleViewAttributes, "Center");
            this.jPanelBottleView.revalidate();
        }
    }

    private void buildAttributComponents() {
        this.stringAttributesLabels = new ArrayList();
        this.textAttributes = new ArrayList();
        this.imageViewer = null;
        this.imageList = new ArrayList();
        this.jComboBottleAttributesImage = null;
        this.valueAttributesLabels = new ArrayList();
        this.valueAttributes = new ArrayList();
        this.boolAttributesLabels = new ArrayList();
        this.boolAttributes = new ArrayList();
        this.dropAttributesLabels = new ArrayList();
        this.dropAttributes = new ArrayList();
        this.rateAttributesLabels = new ArrayList();
        this.rateAttributes = new ArrayList();
        for (int i = 0; i < CellarBottle.modifAttributeList.length; ++i) {
            JLabel newLabel;
            CellarBottle.ATTRIBUTE_TYPES attribType = CellarBottle.attributeToType(CellarBottle.modifAttributeList[i]);
            if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST) {
                JTextArea newTextArea;
                newLabel = new JLabel(CellarBottle.modifAttributeList[i]);
                this.stringAttributesLabels.add(newLabel);
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                    newTextArea = new JTextArea(1, 15);
                    newTextArea.setLineWrap(true);
                } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST) {
                    newTextArea = new JTextArea(2, 15);
                    newTextArea.setLineWrap(false);
                } else {
                    newTextArea = new JTextArea(3, 15);
                    newTextArea.setLineWrap(true);
                }
                this.textAttributes.add(newTextArea);
            }
            if (attribType == CellarBottle.ATTRIBUTE_TYPES.BOOL) {
                newLabel = new JLabel(CellarBottle.modifAttributeList[i]);
                this.boolAttributesLabels.add(newLabel);
                JCheckBox newCheckBox = new JCheckBox();
                this.boolAttributes.add(newCheckBox);
            }
            if (attribType == CellarBottle.ATTRIBUTE_TYPES.DROP_DOWN) {
                newLabel = new JLabel(CellarBottle.modifAttributeList[i]);
                this.dropAttributesLabels.add(newLabel);
            }
            if (attribType == CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH) {
                if (this.jComboBottleAttributesImage == null) {
                    this.jComboBottleAttributesImage = new JComboBox();
                    this.jComboBottleAttributesImage.addActionListener(this);
                    this.imageViewer = new ImagePanel();
                    this.imageViewer.addPropertyChangeListener("image", this);
                }
                this.imageList.add(CellarBottle.modifAttributeList[i]);
            }
            if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_DOUBLE || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_INT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_PERCENT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_MONEY || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR) {
                newLabel = new JLabel(CellarBottle.modifAttributeList[i]);
                this.valueAttributesLabels.add(newLabel);
                JFormattedTextField newTextField = new JFormattedTextField(this.buildFormatFactory(attribType));
                newTextField.setFocusLostBehavior(0);
                newTextField.addFocusListener(this);
                this.valueAttributes.add(newTextField);
            }
            if (attribType != CellarBottle.ATTRIBUTE_TYPES.RATE) continue;
            newLabel = new JLabel(CellarBottle.modifAttributeList[i]);
            this.rateAttributesLabels.add(newLabel);
            RatingLabel newRateLabel = new RatingLabel();
            this.rateAttributes.add(newRateLabel);
        }
    }

    private void buildExtraAttributComponents() {
        if (this.curBottle != null) {
            int i;
            this.stringExtraAttributesLabels = new ArrayList();
            this.textExtraAttributes = new ArrayList();
            this.extraImageList = new ArrayList();
            this.valueExtraAttributesLabels = new ArrayList();
            this.valueExtraAttributes = new ArrayList();
            this.dropExtraAttributesLabels = new ArrayList();
            this.dropExtraAttributes = new ArrayList();
            this.boolExtraAttributesLabels = new ArrayList();
            this.boolExtraAttributes = new ArrayList();
            this.rateExtraAttributesLabels = new ArrayList();
            this.rateExtraAttributes = new ArrayList();
            this.dropAttributes = new ArrayList();
            for (i = 0; i < this.curBottle.getExtraAttributeList().length; ++i) {
                JLabel newLabel;
                CellarBottle.ATTRIBUTE_TYPES attribType = this.curBottle.getExtraAttributeTypeList()[i];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST) {
                    JTextArea newTextArea;
                    newLabel = new JLabel(this.curBottle.getExtraAttributeList()[i]);
                    this.stringExtraAttributesLabels.add(newLabel);
                    if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                        newTextArea = new JTextArea(1, 15);
                        newTextArea.setLineWrap(true);
                    } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST) {
                        newTextArea = new JTextArea(2, 15);
                        newTextArea.setLineWrap(false);
                    } else {
                        newTextArea = new JTextArea(3, 15);
                        newTextArea.setLineWrap(true);
                    }
                    newTextArea.setLineWrap(false);
                    this.textExtraAttributes.add(newTextArea);
                }
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.BOOL) {
                    newLabel = new JLabel(this.curBottle.getExtraAttributeList()[i]);
                    this.boolExtraAttributesLabels.add(newLabel);
                    JCheckBox newCheckBox = new JCheckBox();
                    this.boolExtraAttributes.add(newCheckBox);
                }
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.DROP_DOWN) {
                    newLabel = new JLabel(this.curBottle.getExtraAttributeList()[i]);
                    this.dropExtraAttributesLabels.add(newLabel);
                    JComboBox<String> newDropDown = new JComboBox<String>();
                    newDropDown.setPreferredSize(new Dimension(182, 10));
                    newDropDown.setEditable(false);
                    for (int k = 0; k < this.curBottle.getDropExtraAttributeLists(i).length; ++k) {
                        newDropDown.addItem(this.curBottle.getDropAttributeLists(i)[k]);
                    }
                    this.dropExtraAttributes.add(newDropDown);
                }
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH) {
                    if (this.jComboBottleAttributesImage == null) {
                        this.jComboBottleAttributesImage = new JComboBox();
                        this.jComboBottleAttributesImage.addActionListener(this);
                        this.imageViewer = new ImagePanel();
                        this.imageViewer.addPropertyChangeListener("image", this);
                    }
                    this.extraImageList.add(this.curBottle.getExtraAttributeList()[i]);
                }
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_DOUBLE || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_INT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_PERCENT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_MONEY || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR) {
                    newLabel = new JLabel(this.curBottle.getExtraAttributeList()[i]);
                    this.valueExtraAttributesLabels.add(newLabel);
                    JFormattedTextField newTextField = new JFormattedTextField(this.buildFormatFactory(attribType));
                    newTextField.setFocusLostBehavior(0);
                    newTextField.addFocusListener(this);
                    this.valueExtraAttributes.add(newTextField);
                }
                if (attribType != CellarBottle.ATTRIBUTE_TYPES.RATE) continue;
                newLabel = new JLabel(this.curBottle.getExtraAttributeList()[i]);
                this.rateExtraAttributesLabels.add(newLabel);
                RatingLabel newRateLabel = new RatingLabel();
                this.rateExtraAttributes.add(newRateLabel);
            }
            for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                int attributeIndex = CellarBottle.attributeToIndex(this.dropAttributesLabels.get(i).getText());
                if (attributeIndex < 0) continue;
                JComboBox<String> newDropDown = new JComboBox<String>();
                newDropDown.setPreferredSize(new Dimension(182, 20));
                newDropDown.setEditable(true);
                for (int k = 0; k < this.curBottle.getDropAttributeLists(attributeIndex).length; ++k) {
                    newDropDown.addItem(this.curBottle.getDropAttributeLists(attributeIndex)[k]);
                }
                this.dropAttributes.add(newDropDown);
            }
        }
    }

    private JFormattedTextField.AbstractFormatterFactory buildFormatFactory(CellarBottle.ATTRIBUTE_TYPES attribType) {
        DefaultFormatterFactory valueFormatFactory = new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getNumberInstance()));
        if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_INT) {
            NumberFormatter valueFormatter = new NumberFormatter(NumberFormat.getNumberInstance());
            valueFormatter.setValueClass(Integer.class);
            valueFormatter.setCommitsOnValidEdit(true);
            valueFormatter.setMinimum(Integer.valueOf(0));
            valueFormatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
            valueFormatFactory = new DefaultFormatterFactory(valueFormatter);
        } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_DOUBLE) {
            NumberFormatter valueFormatter = new NumberFormatter(NumberFormat.getNumberInstance());
            valueFormatter.setValueClass(Double.class);
            valueFormatter.setCommitsOnValidEdit(true);
            valueFormatFactory = new DefaultFormatterFactory(valueFormatter);
        } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_PERCENT) {
            NumberFormat percentDisplayFormat = NumberFormat.getPercentInstance();
            percentDisplayFormat.setMinimumFractionDigits(1);
            percentDisplayFormat.setMaximumFractionDigits(2);
            NumberFormatter valueDisplayFormatter = new NumberFormatter(percentDisplayFormat);
            valueDisplayFormatter.setValueClass(Double.class);
            valueDisplayFormatter.setMinimum(Double.valueOf(0.0));
            valueDisplayFormatter.setMaximum(Double.valueOf(100.0));
            DecimalFormat percentEditFormat = new DecimalFormat("#.0#");
            ((NumberFormat)percentEditFormat).setGroupingUsed(false);
            ((NumberFormat)percentEditFormat).setMinimumFractionDigits(1);
            ((NumberFormat)percentEditFormat).setMaximumFractionDigits(2);
            NumberFormatter percentEditFormatter = new NumberFormatter(percentEditFormat){

                @Override
                public String valueToString(Object o) throws ParseException {
                    Number number = (Number)o;
                    if (number != null) {
                        double d = number.doubleValue() * 100.0;
                        number = new Double(d);
                    }
                    return super.valueToString(number);
                }

                @Override
                public Object stringToValue(String s) throws ParseException {
                    Number number = (Number)super.stringToValue(s);
                    if (number != null) {
                        double d = number.doubleValue() / 100.0;
                        number = new Double(d);
                    }
                    return number;
                }
            };
            percentEditFormatter.setCommitsOnValidEdit(true);
            percentEditFormatter.setMinimum(Double.valueOf(0.0));
            percentEditFormatter.setMaximum(Double.valueOf(100.0));
            valueFormatFactory = new DefaultFormatterFactory(valueDisplayFormatter, valueDisplayFormatter, percentEditFormatter);
        } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_MONEY) {
            NumberFormat amountDisplayFormat = NumberFormat.getCurrencyInstance();
            amountDisplayFormat.setMinimumFractionDigits(2);
            NumberFormatter valueDisplayFormatter = new NumberFormatter(amountDisplayFormat);
            valueDisplayFormatter.setMinimum(Double.valueOf(0.0));
            valueDisplayFormatter.setMaximum(Double.valueOf(Double.MAX_VALUE));
            NumberFormat amountEditFormat = NumberFormat.getNumberInstance();
            amountEditFormat.setGroupingUsed(false);
            NumberFormatter valueEditFormatter = new NumberFormatter(amountEditFormat);
            valueEditFormatter.setValueClass(Double.class);
            valueEditFormatter.setCommitsOnValidEdit(true);
            valueEditFormatter.setMinimum(Double.valueOf(0.0));
            valueEditFormatter.setMaximum(Double.valueOf(Double.MAX_VALUE));
            valueFormatFactory = new DefaultFormatterFactory(valueDisplayFormatter, valueDisplayFormatter, valueEditFormatter);
        } else if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR) {
            NumberFormat yearFormat = NumberFormat.getIntegerInstance();
            yearFormat.setGroupingUsed(false);
            NumberFormatter valueFormatter = new NumberFormatter(yearFormat);
            valueFormatter.setValueClass(Integer.class);
            valueFormatter.setCommitsOnValidEdit(true);
            valueFormatter.setMinimum(Integer.valueOf(0));
            valueFormatter.setMaximum(Integer.valueOf(3000));
            valueFormatFactory = new DefaultFormatterFactory(valueFormatter);
        }
        return valueFormatFactory;
    }

    private void buildBottleView() {
        if (this.jPanelBottleView != null && this.curBottle != null) {
            JScrollPane newScroll;
            int i;
            this.jPanelStringAttributesView.removeAll();
            this.jPanelValueAttributesView.removeAll();
            this.jPanelImageAttributesView.removeAll();
            this.jPanelStringAttributesView.setLayout(new GridBagLayout());
            GridBagConstraints gridLayoutConstraints = new GridBagConstraints();
            gridLayoutConstraints.fill = 0;
            gridLayoutConstraints.ipadx = 0;
            gridLayoutConstraints.ipady = 0;
            gridLayoutConstraints.weightx = 0.5;
            gridLayoutConstraints.weighty = 0.0;
            gridLayoutConstraints.anchor = 23;
            gridLayoutConstraints.insets = new Insets(5, 5, 5, 5);
            gridLayoutConstraints.gridx = 0;
            gridLayoutConstraints.gridy = 0;
            gridLayoutConstraints.gridwidth = 1;
            gridLayoutConstraints.gridheight = 1;
            for (i = 0; i < this.stringAttributesLabels.size(); ++i) {
                if (i == this.stringAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weighty = 0.5;
                }
                gridLayoutConstraints.gridx = 0;
                this.jPanelStringAttributesView.add((Component)this.stringAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridx = 1;
                newScroll = new JScrollPane(this.textAttributes.get(i));
                newScroll.setHorizontalScrollBarPolicy(31);
                newScroll.setVerticalScrollBarPolicy(20);
                newScroll.setBorder(null);
                this.jPanelStringAttributesView.add((Component)newScroll, gridLayoutConstraints);
                ++gridLayoutConstraints.gridy;
            }
            gridLayoutConstraints.weighty = 0.0;
            for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                if (i == this.dropAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weighty = 0.5;
                }
                gridLayoutConstraints.gridx = 0;
                this.jPanelStringAttributesView.add((Component)this.dropAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridx = 1;
                this.jPanelStringAttributesView.add((Component)this.dropAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridy;
            }
            gridLayoutConstraints.weighty = 0.0;
            for (i = 0; i < this.stringExtraAttributesLabels.size(); ++i) {
                if (i == this.stringExtraAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weighty = 0.5;
                }
                gridLayoutConstraints.gridx = 0;
                this.jPanelStringAttributesView.add((Component)this.stringExtraAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridx = 1;
                newScroll = new JScrollPane(this.textExtraAttributes.get(i));
                newScroll.setHorizontalScrollBarPolicy(31);
                newScroll.setVerticalScrollBarPolicy(20);
                newScroll.setBorder(null);
                this.jPanelStringAttributesView.add((Component)newScroll, gridLayoutConstraints);
                ++gridLayoutConstraints.gridy;
            }
            gridLayoutConstraints.weighty = 0.0;
            for (i = 0; i < this.dropExtraAttributesLabels.size(); ++i) {
                if (i == this.dropExtraAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weighty = 0.5;
                }
                gridLayoutConstraints.gridx = 0;
                this.jPanelStringAttributesView.add((Component)this.dropExtraAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridx = 1;
                this.jPanelStringAttributesView.add((Component)this.dropExtraAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridy;
            }
            this.jPanelValueAttributesView.setLayout(new GridBagLayout());
            gridLayoutConstraints.fill = 2;
            gridLayoutConstraints.ipadx = 0;
            gridLayoutConstraints.ipady = 0;
            gridLayoutConstraints.weightx = 0.0;
            gridLayoutConstraints.weighty = 0.5;
            gridLayoutConstraints.anchor = 23;
            gridLayoutConstraints.insets = new Insets(5, 5, 5, 5);
            gridLayoutConstraints.gridx = 0;
            gridLayoutConstraints.gridy = 0;
            gridLayoutConstraints.gridwidth = 1;
            gridLayoutConstraints.gridheight = 1;
            for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                if (i == this.valueAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.valueAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.valueAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            for (i = 0; i < this.valueExtraAttributesLabels.size(); ++i) {
                if (i == this.valueExtraAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.valueExtraAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.valueExtraAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            gridLayoutConstraints.fill = 0;
            for (i = 0; i < this.boolAttributesLabels.size(); ++i) {
                if (i == this.boolAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.boolAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.boolAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            for (i = 0; i < this.boolExtraAttributesLabels.size(); ++i) {
                if (i == this.boolExtraAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.boolExtraAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.boolExtraAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            gridLayoutConstraints.fill = 0;
            for (i = 0; i < this.rateAttributesLabels.size(); ++i) {
                if (i == this.rateAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.rateAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.rateAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            for (i = 0; i < this.rateExtraAttributesLabels.size(); ++i) {
                if (i == this.rateExtraAttributesLabels.size() - 1) {
                    gridLayoutConstraints.weightx = 0.5;
                }
                gridLayoutConstraints.gridy = 0;
                this.jPanelValueAttributesView.add((Component)this.rateExtraAttributesLabels.get(i), gridLayoutConstraints);
                gridLayoutConstraints.gridy = 1;
                this.jPanelValueAttributesView.add((Component)this.rateExtraAttributes.get(i), gridLayoutConstraints);
                ++gridLayoutConstraints.gridx;
            }
            if (this.imageViewer != null) {
                this.jComboBottleAttributesImage.removeAllItems();
                for (i = 0; i < this.imageList.size(); ++i) {
                    this.jComboBottleAttributesImage.addItem(this.imageList.get(i));
                }
                for (i = 0; i < this.extraImageList.size(); ++i) {
                    this.jComboBottleAttributesImage.addItem(this.extraImageList.get(i));
                }
                JPanel comboPanel = new JPanel();
                comboPanel.add(this.jComboBottleAttributesImage);
                this.jPanelImageAttributesView.add((Component)comboPanel, "North");
                this.jPanelImageAttributesView.add((Component)this.imageViewer, "Center");
                this.jComboBottleAttributesImage.setSelectedIndex(0);
            }
            this.jPanelBottleView.revalidate();
            this.jPanelBottleView.repaint();
        } else {
            this.jPanelStringAttributesView.removeAll();
            this.jPanelValueAttributesView.removeAll();
            this.jPanelImageAttributesView.removeAll();
            this.jPanelBottleView.revalidate();
            this.jPanelBottleView.repaint();
        }
    }

    private void updateBottleView() {
        if (this.jPanelBottleView != null && this.curBottle != null) {
            this.jComboBottleType.setVisible(true);
            this.jLabelBottleType.setVisible(true);
            if (this.edit.equals((Object)ViewMode.ADD)) {
                this.jButtonOK.setText("Add bottle");
            }
            if (this.edit.equals((Object)ViewMode.EDIT)) {
                this.jButtonOK.setText("Save bottle");
            }
            if (this.edit.equals((Object)ViewMode.VIEW)) {
                int i;
                this.jComboBottleType.setEnabled(false);
                this.jButtonCancel.setVisible(false);
                this.jButtonCancel.setEnabled(false);
                this.jButtonOK.setVisible(false);
                this.jButtonOK.setEnabled(false);
                for (i = 0; i < this.stringAttributesLabels.size(); ++i) {
                    this.textAttributes.get(i).setEditable(false);
                    this.textAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.textAttributes.get(i).setBackground(this.jPanelStringAttributesView.getBackground());
                }
                for (i = 0; i < this.stringExtraAttributesLabels.size(); ++i) {
                    this.textExtraAttributes.get(i).setEditable(false);
                    this.textExtraAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.textExtraAttributes.get(i).setBackground(this.jPanelStringAttributesView.getBackground());
                }
                for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                    this.dropAttributes.get(i).setEnabled(false);
                }
                for (i = 0; i < this.dropExtraAttributesLabels.size(); ++i) {
                    this.dropExtraAttributes.get(i).setEnabled(false);
                }
                for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                    this.valueAttributes.get(i).setEditable(false);
                    this.valueAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.valueAttributes.get(i).setBackground(this.jPanelValueAttributesView.getBackground());
                }
                for (i = 0; i < this.valueExtraAttributesLabels.size(); ++i) {
                    this.valueExtraAttributes.get(i).setEditable(false);
                    this.valueExtraAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.valueExtraAttributes.get(i).setBackground(this.jPanelValueAttributesView.getBackground());
                }
                for (i = 0; i < this.boolAttributesLabels.size(); ++i) {
                    this.boolAttributes.get(i).setEnabled(false);
                    this.boolAttributes.get(i).setBorderPaintedFlat(true);
                }
                for (i = 0; i < this.boolExtraAttributesLabels.size(); ++i) {
                    this.boolExtraAttributes.get(i).setEnabled(false);
                    this.boolExtraAttributes.get(i).setBorderPaintedFlat(true);
                }
                for (i = 0; i < this.rateAttributesLabels.size(); ++i) {
                    this.rateAttributes.get(i).setEditable(false);
                    this.rateAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.rateAttributes.get(i).setBackground(this.jPanelValueAttributesView.getBackground());
                }
                for (i = 0; i < this.rateExtraAttributesLabels.size(); ++i) {
                    this.rateExtraAttributes.get(i).setEditable(false);
                    this.rateExtraAttributes.get(i).setBorder(BorderFactory.createEmptyBorder());
                    this.rateExtraAttributes.get(i).setBackground(this.jPanelValueAttributesView.getBackground());
                }
                if (this.imageViewer != null) {
                    this.imageViewer.setEnabled(false);
                    this.imageViewer.setBorder(BorderFactory.createEmptyBorder());
                }
            } else {
                int i;
                this.jComboBottleType.setEnabled(true);
                this.jButtonCancel.setVisible(true);
                this.jButtonCancel.setEnabled(true);
                this.jButtonOK.setVisible(true);
                this.jButtonOK.setEnabled(true);
                for (i = 0; i < this.stringAttributesLabels.size(); ++i) {
                    this.textAttributes.get(i).setEditable(true);
                    this.textAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.textAttributes.get(i).setBackground(Color.white);
                }
                for (i = 0; i < this.stringExtraAttributesLabels.size(); ++i) {
                    this.textExtraAttributes.get(i).setEditable(true);
                    this.textExtraAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.textExtraAttributes.get(i).setBackground(Color.white);
                }
                for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                    this.dropAttributes.get(i).setEnabled(true);
                }
                for (i = 0; i < this.dropExtraAttributesLabels.size(); ++i) {
                    this.dropExtraAttributes.get(i).setEnabled(true);
                }
                for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                    this.valueAttributes.get(i).setEditable(true);
                    this.valueAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.valueAttributes.get(i).setBackground(Color.white);
                }
                for (i = 0; i < this.valueExtraAttributesLabels.size(); ++i) {
                    this.valueExtraAttributes.get(i).setEditable(true);
                    this.valueExtraAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.valueExtraAttributes.get(i).setBackground(Color.white);
                }
                for (i = 0; i < this.boolAttributesLabels.size(); ++i) {
                    this.boolAttributes.get(i).setEnabled(true);
                    this.boolAttributes.get(i).setBorderPaintedFlat(false);
                }
                for (i = 0; i < this.boolExtraAttributesLabels.size(); ++i) {
                    this.boolExtraAttributes.get(i).setEnabled(true);
                    this.boolExtraAttributes.get(i).setBorderPaintedFlat(false);
                }
                for (i = 0; i < this.rateAttributesLabels.size(); ++i) {
                    this.rateAttributes.get(i).setEditable(true);
                    this.rateAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.rateAttributes.get(i).setBackground(Color.white);
                }
                for (i = 0; i < this.rateExtraAttributesLabels.size(); ++i) {
                    this.rateExtraAttributes.get(i).setEditable(true);
                    this.rateExtraAttributes.get(i).setBorder(BorderFactory.createLineBorder(Color.black));
                    this.rateExtraAttributes.get(i).setBackground(Color.white);
                }
                if (this.imageViewer != null) {
                    this.imageViewer.setEnabled(true);
                    this.imageViewer.setBorder(BorderFactory.createLineBorder(Color.black));
                }
            }
        } else if (this.curBottle == null) {
            this.jComboBottleType.setVisible(false);
            this.jLabelBottleType.setVisible(false);
            this.jButtonCancel.setVisible(false);
            this.jButtonOK.setVisible(false);
        }
    }

    private void updateBottleFields() {
        if (this.curBottle != null) {
            int k;
            String[] stringList;
            CellarBottle.ATTRIBUTE_TYPES attribType;
            int attribIndex;
            int i;
            this.imageArray = new ArrayList();
            this.extraImageArray = new ArrayList();
            for (i = 0; i < this.jComboBottleType.getItemCount(); ++i) {
                if (!this.curBottle.getSubClass().equals((String)this.jComboBottleType.getItemAt(i))) continue;
                this.jComboBottleType.setSelectedIndex(i);
            }
            for (i = 0; i < this.stringAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.stringAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = CellarBottle.allAttributeTypeList[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                    this.textAttributes.get(i).setText((String)this.curBottle.getAttribute(attribIndex));
                    continue;
                }
                stringList = (String[])this.curBottle.getAttribute(attribIndex);
                this.textAttributes.get(i).setText("");
                for (k = 0; k < stringList.length; ++k) {
                    if (k == stringList.length - 1) {
                        this.textAttributes.get(i).append(stringList[k]);
                        continue;
                    }
                    this.textAttributes.get(i).append(stringList[k] + "\n");
                }
                this.textAttributes.get(i).select(0, 0);
            }
            for (i = 0; i < this.stringExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.stringExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = this.curBottle.getExtraAttributeTypeList()[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                    this.textExtraAttributes.get(i).setText((String)this.curBottle.getExtraAttribute(attribIndex));
                    continue;
                }
                stringList = (String[])this.curBottle.getExtraAttribute(attribIndex);
                this.textExtraAttributes.get(i).setText("");
                for (k = 0; k < stringList.length; ++k) {
                    if (k == stringList.length - 1) {
                        this.textExtraAttributes.get(i).append(stringList[k]);
                        continue;
                    }
                    this.textExtraAttributes.get(i).append(stringList[k] + "\n");
                }
                this.textExtraAttributes.get(i).select(0, 0);
            }
            for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.dropAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.dropAttributes.get(i).setSelectedItem((String)this.curBottle.getAttribute(attribIndex));
            }
            for (i = 0; i < this.dropExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.dropExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.dropExtraAttributes.get(i).setSelectedItem((String)this.curBottle.getExtraAttribute(attribIndex));
            }
            for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.valueAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.valueAttributes.get(i).setValue(this.curBottle.getAttribute(attribIndex));
            }
            for (i = 0; i < this.valueExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.valueExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.valueExtraAttributes.get(i).setValue(this.curBottle.getExtraAttribute(attribIndex));
            }
            for (i = 0; i < this.boolAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.boolAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.boolAttributes.get(i).setSelected((Boolean)this.curBottle.getAttribute(attribIndex));
            }
            for (i = 0; i < this.boolExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.boolExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.boolExtraAttributes.get(i).setSelected((Boolean)this.curBottle.getExtraAttribute(attribIndex));
            }
            for (i = 0; i < this.rateAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.rateAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.rateAttributes.get(i).setRateValue((Double)this.curBottle.getAttribute(attribIndex));
            }
            for (i = 0; i < this.rateExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.rateExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.rateExtraAttributes.get(i).setRateValue((Double)this.curBottle.getExtraAttribute(attribIndex));
            }
            if (this.imageViewer != null) {
                File imgFile;
                String imgPath;
                for (i = 0; i < this.imageList.size(); ++i) {
                    attribIndex = CellarBottle.attributeToIndex(this.imageList.get(i));
                    if (attribIndex < 0) continue;
                    if (!((String)this.curBottle.getAttribute(attribIndex)).isEmpty()) {
                        imgPath = this.databasePath + (String)this.curBottle.getAttribute(attribIndex);
                        imgFile = new File(imgPath);
                        if (imgFile.exists()) {
                            try {
                                BufferedImage newImage = ImageIO.read(imgFile);
                                this.imageArray.add(newImage);
                            }
                            catch (IOException ex) {
                                this.imageArray.add(null);
                                JOptionPane.showMessageDialog(null, "Error loading image file from database. File might have been erased.", "Database Image loading error", 0);
                            }
                            continue;
                        }
                        this.imageArray.add(null);
                        continue;
                    }
                    this.imageArray.add(null);
                }
                for (i = 0; i < this.extraImageList.size(); ++i) {
                    attribIndex = this.curBottle.extraAttributeToIndex(this.extraImageList.get(i));
                    if (attribIndex < 0) continue;
                    if (!((String)this.curBottle.getExtraAttribute(attribIndex)).isEmpty()) {
                        imgPath = this.databasePath + (String)this.curBottle.getExtraAttribute(attribIndex);
                        imgFile = new File(imgPath);
                        if (imgFile.exists()) {
                            try {
                                BufferedImage newImage = ImageIO.read(imgFile);
                                this.extraImageArray.add(newImage);
                            }
                            catch (IOException ex) {
                                this.extraImageArray.add(null);
                                JOptionPane.showMessageDialog(null, "Error loading image file from database. File might have been erased.", "Database Image loading error", 0);
                            }
                            continue;
                        }
                        this.imageArray.add(null);
                        continue;
                    }
                    this.imageArray.add(null);
                }
            }
        }
    }

    private void saveBottleFields() {
        if (this.curBottle != null) {
            String[] stringList;
            CellarBottle.ATTRIBUTE_TYPES attribType;
            int attribIndex;
            int i;
            for (i = 0; i < this.stringAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.stringAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = CellarBottle.allAttributeTypeList[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                    this.curBottle.setAttribute(attribIndex, this.textAttributes.get(i).getText());
                    continue;
                }
                stringList = this.textAttributes.get(i).getText().split("\\n");
                this.curBottle.setAttribute(attribIndex, stringList);
            }
            for (i = 0; i < this.stringExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.stringExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = this.curBottle.getExtraAttributeTypeList()[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.BIG_TEXT || attribType == CellarBottle.ATTRIBUTE_TYPES.TEXT) {
                    this.curBottle.setExtraAttribute(attribIndex, this.textExtraAttributes.get(i).getText());
                    continue;
                }
                stringList = this.textExtraAttributes.get(i).getText().split("\\n");
                this.curBottle.setExtraAttribute(attribIndex, stringList);
            }
            for (i = 0; i < this.dropAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.dropAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setAttribute(attribIndex, this.dropAttributes.get(i).getSelectedItem());
            }
            for (i = 0; i < this.dropExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.dropExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setExtraAttribute(attribIndex, this.dropExtraAttributes.get(i).getSelectedItem());
            }
            for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.valueAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = CellarBottle.allAttributeTypeList[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_INT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR) {
                    this.curBottle.setAttribute(attribIndex, (int)((Integer)this.valueAttributes.get(i).getValue()));
                    continue;
                }
                this.curBottle.setAttribute(attribIndex, (double)((Double)this.valueAttributes.get(i).getValue()));
            }
            for (i = 0; i < this.valueExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.valueExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                attribType = this.curBottle.getExtraAttributeTypeList()[attribIndex];
                if (attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_INT || attribType == CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR) {
                    this.curBottle.setExtraAttribute(attribIndex, (int)((Integer)this.valueExtraAttributes.get(i).getValue()));
                    continue;
                }
                this.curBottle.setExtraAttribute(attribIndex, (double)((Double)this.valueExtraAttributes.get(i).getValue()));
            }
            for (i = 0; i < this.boolAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.boolAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setAttribute(attribIndex, this.boolAttributes.get(i).isSelected());
            }
            for (i = 0; i < this.boolExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.boolExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setExtraAttribute(attribIndex, this.boolExtraAttributes.get(i).isSelected());
            }
            for (i = 0; i < this.rateAttributesLabels.size(); ++i) {
                attribIndex = CellarBottle.attributeToIndex(this.rateAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setAttribute(attribIndex, this.rateAttributes.get(i).getRateValue());
            }
            for (i = 0; i < this.rateExtraAttributesLabels.size(); ++i) {
                attribIndex = this.curBottle.extraAttributeToIndex(this.rateExtraAttributesLabels.get(i).getText());
                if (attribIndex < 0) continue;
                this.curBottle.setExtraAttribute(attribIndex, this.rateExtraAttributes.get(i).getRateValue());
            }
            if (this.imageViewer != null) {
                File newImageFile;
                String imgPath;
                for (i = 0; i < this.imageList.size(); ++i) {
                    attribIndex = CellarBottle.attributeToIndex(this.imageList.get(i));
                    if (attribIndex < 0) continue;
                    if (this.imageArray.get(i) != null) {
                        imgPath = this.databasePath + "\\ImageFolder\\" + this.curBottle.getBtleID().toString() + this.imageList.get(i) + ".jpg";
                        newImageFile = new File(imgPath);
                        try {
                            ImageIO.write((RenderedImage)this.imageArray.get(i), "jpeg", newImageFile);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(null, "Error saving image file to database folder.", "Database Image saving error", 0);
                        }
                        this.curBottle.setAttribute(attribIndex, "\\ImageFolder\\" + this.curBottle.getBtleID().toString() + this.imageList.get(i) + ".jpg");
                        continue;
                    }
                    this.curBottle.setAttribute(attribIndex, "");
                }
                for (i = 0; i < this.extraImageList.size(); ++i) {
                    attribIndex = this.curBottle.extraAttributeToIndex(this.extraImageList.get(i));
                    if (attribIndex < 0) continue;
                    if (this.imageArray.get(i) != null) {
                        imgPath = this.databasePath + "\\ImageFolder\\" + this.curBottle.getBtleID().toString() + this.extraImageList.get(i) + ".jpg";
                        newImageFile = new File(imgPath);
                        try {
                            ImageIO.write((RenderedImage)this.extraImageArray.get(i), "jpeg", newImageFile);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(null, "Error saving image file to database folder.", "Database Image saving error", 0);
                        }
                        this.curBottle.setExtraAttribute(attribIndex, "\\ImageFolder\\" + this.curBottle.getBtleID().toString() + this.imageList.get(i) + ".jpg");
                        continue;
                    }
                    this.curBottle.setExtraAttribute(attribIndex, "");
                }
            }
        }
    }

    public void bottleChanged(CellarBottle bottleToView) {
        this.curBottle = bottleToView;
        this.buildExtraAttributComponents();
        this.updateBottleFields();
        this.updateBottleView();
        this.buildBottleView();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.jComboBottleType) {
            if (this.jComboBottleType.isEnabled() && !this.curBottle.getSubClass().equals((String)this.jComboBottleType.getSelectedItem())) {
                if ("WineCellarBottle".equalsIgnoreCase((String)this.jComboBottleType.getSelectedItem())) {
                    this.bottleChanged(new WineCellarBottle());
                } else if ("SpiritCellarBottle".equalsIgnoreCase((String)this.jComboBottleType.getSelectedItem())) {
                    this.bottleChanged(new SpiritCellarBottle());
                }
            }
            return;
        }
        if (src == this.jButtonCancel) {
            this.setEdit(ViewMode.VIEW);
            this.bottleChanged(this.oldBottle);
            for (int i = 0; i < this.valueAttributesLabels.size(); ++i) {
                this.valueAttributes.get(i).setForeground(Color.BLACK);
            }
            return;
        }
        if (src == this.jButtonOK) {
            int i;
            for (i = 0; i < this.valueAttributesLabels.size(); ++i) {
                if (this.valueAttributes.get(i).isEditValid()) continue;
                JOptionPane.showMessageDialog(null, "Some values are invalid. Please correct values or discard.", "Incorrect values", 0);
                return;
            }
            if (this.edit.equals((Object)ViewMode.EDIT) && !this.oldBottle.equals(this.curBottle)) {
                for (i = 0; i < CellarBottle.modifAttributeList.length; ++i) {
                    String imgPath;
                    File imgFile;
                    CellarBottle.ATTRIBUTE_TYPES attribType;
                    int attribIndex = CellarBottle.attributeToIndex(CellarBottle.modifAttributeList[i]);
                    if (attribIndex < 0 || (attribType = CellarBottle.allAttributeTypeList[attribIndex]) != CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH || !(imgFile = new File(imgPath = this.databasePath + (String)this.oldBottle.getAttribute(attribIndex))).exists()) continue;
                    imgFile.delete();
                }
                for (i = 0; i < this.oldBottle.getExtraAttributeList().length; ++i) {
                    String imgPath;
                    File imgFile;
                    CellarBottle.ATTRIBUTE_TYPES attribType = this.oldBottle.getExtraAttributeTypeList()[i];
                    if (attribType != CellarBottle.ATTRIBUTE_TYPES.IMAGE_PATH || !(imgFile = new File(imgPath = this.databasePath + (String)this.oldBottle.getExtraAttribute(i))).exists() || !imgFile.exists()) continue;
                    imgFile.delete();
                }
            }
            this.saveBottleFields();
            if (this.edit.equals((Object)ViewMode.ADD)) {
                this.fireBottleAdded();
            } else {
                this.fireBottleChanged();
            }
            this.setEdit(ViewMode.VIEW);
            return;
        }
        if (src == this.jComboBottleAttributesImage) {
            int i;
            for (i = 0; i < this.imageList.size(); ++i) {
                if (!this.imageList.get(i).equals((String)this.jComboBottleAttributesImage.getSelectedItem())) continue;
                this.imageViewer.setImage(this.imageArray.get(i));
                return;
            }
            for (i = 0; i < this.extraImageList.size(); ++i) {
                if (!this.extraImageList.get(i).equals((String)this.jComboBottleAttributesImage.getSelectedItem())) continue;
                this.imageViewer.setImage(this.extraImageArray.get(i));
                return;
            }
            return;
        }
        throw new UnsupportedOperationException("Action is not supported yet.");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object src = pce.getSource();
        if (src == this.imageViewer && "image".equals(pce.getPropertyName())) {
            for (int i = 0; i < this.imageList.size(); ++i) {
                if (!this.imageList.get(i).equals((String)this.jComboBottleAttributesImage.getSelectedItem())) continue;
                this.imageArray.set(i, (BufferedImage)pce.getNewValue());
                return;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        Object src = fe.getSource();
        if (src.getClass() == JFormattedTextField.class) {
            if (((JFormattedTextField)src).isEditValid()) {
                ((JFormattedTextField)src).setForeground(Color.BLACK);
            } else {
                ((JFormattedTextField)src).setForeground(Color.RED);
            }
        }
    }

    public void addBottleListener(BottleListener listener) {
        this.listeners.add(BottleListener.class, listener);
    }

    public void removeBottleListener(BottleListener listener) {
        this.listeners.remove(BottleListener.class, listener);
    }

    public void fireBottleAdded() {
        BottleListener[] bottleListenerList;
        for (BottleListener listener : bottleListenerList = (BottleListener[])this.listeners.getListeners(BottleListener.class)) {
            listener.bottleAdded(new BottleAddedEvent(this, this.curBottle));
        }
    }

    public void fireBottleChanged() {
        BottleListener[] bottleListenerList;
        for (BottleListener listener : bottleListenerList = (BottleListener[])this.listeners.getListeners(BottleListener.class)) {
            listener.bottleChanged(new BottleAddedEvent(this, this.curBottle));
        }
    }

    public static enum ViewMode {
        VIEW,
        EDIT,
        ADD;

    }
}

