/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;

public class ListCellRenderer
implements TableCellRenderer,
TableCellEditor,
AdjustmentListener {
    private JScrollPane scrollPaneRender;
    private JScrollPane scrollPaneEdit;
    private JTextArea textAreaRender;
    private JTextArea textAreaEdit;
    private HashMap<Integer, Integer> scrollPositions = new HashMap();
    private int scrollPaneEditRow;
    private int scrollPaneRenderRow;

    public ListCellRenderer() {
        this.textAreaRender = new JTextArea();
        this.textAreaRender.setEditable(false);
        this.textAreaRender.setBorder(null);
        this.textAreaRender.setOpaque(true);
        DefaultCaret caret = (DefaultCaret)this.textAreaRender.getCaret();
        caret.setUpdatePolicy(1);
        this.scrollPaneRender = new JScrollPane(this.textAreaRender);
        this.scrollPaneRender.setHorizontalScrollBarPolicy(31);
        this.scrollPaneRender.setVerticalScrollBarPolicy(20);
        this.scrollPaneRender.setBackground(UIManager.getColor("Table.background"));
        this.scrollPaneRender.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.textAreaEdit = new JTextArea();
        this.textAreaEdit.setEditable(false);
        this.textAreaEdit.setBorder(null);
        this.textAreaEdit.setOpaque(true);
        caret = (DefaultCaret)this.textAreaEdit.getCaret();
        caret.setUpdatePolicy(1);
        this.scrollPaneEdit = new JScrollPane(this.textAreaEdit);
        this.scrollPaneEdit.setHorizontalScrollBarPolicy(31);
        this.scrollPaneEdit.setVerticalScrollBarPolicy(20);
        this.scrollPaneEdit.setBackground(UIManager.getColor("Table.background"));
        this.scrollPaneEdit.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scrollPaneEdit.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollPaneRender.getVerticalScrollBar().addAdjustmentListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textAreaRender.setText("");
        String[] cellList = (String[])value;
        String listText = "";
        for (int i = 0; i < cellList.length; ++i) {
            if (i == cellList.length - 1) {
                listText = listText + cellList[i];
                this.textAreaRender.append(cellList[i]);
                continue;
            }
            listText = listText + cellList[i] + ", ";
            this.textAreaRender.append(cellList[i] + "\n");
        }
        this.textAreaRender.setToolTipText(listText);
        this.textAreaRender.setFont(table.getFont());
        if (isSelected) {
            this.textAreaRender.setForeground(UIManager.getColor("Table.selectionForeground"));
            this.textAreaRender.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.scrollPaneRender.setBackground(UIManager.getColor("Table.selectionBackground"));
            if (hasFocus) {
                this.scrollPaneRender.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.scrollPaneRender.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        } else {
            this.textAreaRender.setForeground(UIManager.getColor("Table.foreground"));
            this.textAreaRender.setBackground(UIManager.getColor("Table.background"));
            this.scrollPaneRender.setBackground(UIManager.getColor("Table.background"));
            this.scrollPaneRender.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        if (cellList.length <= 1) {
            int borderHeight = (table.getRowHeight(row) - this.textAreaRender.getFontMetrics(table.getFont()).getHeight() - 4) / 2;
            this.scrollPaneRender.setViewportBorder(BorderFactory.createEmptyBorder(borderHeight, 0, borderHeight, 0));
        } else {
            this.scrollPaneRender.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        if (!this.scrollPositions.containsKey(row)) {
            this.scrollPositions.put(row, 0);
        }
        this.scrollPaneRenderRow = row;
        this.scrollPaneRender.getVerticalScrollBar().setValue(this.scrollPositions.get(row));
        return this.scrollPaneRender;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textAreaEdit.setText("");
        String[] cellList = (String[])value;
        String listText = "";
        for (int i = 0; i < cellList.length; ++i) {
            if (i == cellList.length - 1) {
                listText = listText + cellList[i];
                this.textAreaEdit.append(cellList[i]);
                continue;
            }
            listText = listText + cellList[i] + ", ";
            this.textAreaEdit.append(cellList[i] + "\n");
        }
        this.textAreaEdit.setToolTipText(listText);
        this.textAreaEdit.setFont(table.getFont());
        this.textAreaEdit.setForeground(UIManager.getColor("Table.selectionForeground"));
        this.textAreaEdit.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.scrollPaneEdit.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.scrollPaneEdit.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (cellList.length <= 1) {
            int borderHeight = (table.getRowHeight(row) - this.textAreaRender.getFontMetrics(table.getFont()).getHeight() - 4) / 2;
            this.scrollPaneEdit.setViewportBorder(BorderFactory.createEmptyBorder(borderHeight, 0, borderHeight, 0));
        } else {
            this.scrollPaneEdit.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        if (!this.scrollPositions.containsKey(row)) {
            this.scrollPositions.put(row, 0);
        }
        this.scrollPaneEditRow = row;
        this.scrollPaneEdit.getVerticalScrollBar().setValue(this.scrollPositions.get(row));
        return this.scrollPaneEdit;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject eo) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener cl) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cl) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object src = e.getSource();
        if (src == this.scrollPaneRender.getVerticalScrollBar()) {
            this.scrollPaneRender.getVerticalScrollBar().setValue(this.scrollPositions.get(this.scrollPaneRenderRow));
            return;
        }
        if (src == this.scrollPaneEdit.getVerticalScrollBar()) {
            this.scrollPositions.put(this.scrollPaneEditRow, this.scrollPaneEdit.getVerticalScrollBar().getValue());
            return;
        }
        throw new UnsupportedOperationException("Action is not supported yet.");
    }
}

