/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;

public class TextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    private HashMap<Integer, HashMap<Integer, Integer>> rowColHeights = new HashMap();
    private int minRowHeight;

    public TextAreaCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
        this.setBorder(null);
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.minRowHeight = 0;
    }

    public TextAreaCellRenderer(int minRowHeight) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
        this.setBorder(null);
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.minRowHeight = minRowHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String[] cellList = (String[])value;
        String listText = "";
        for (int i = 0; i < cellList.length; ++i) {
            listText = i == cellList.length - 1 ? listText + cellList[i] : listText + cellList[i] + ", ";
        }
        this.setToolTipText(listText);
        this.setText(listText);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), 100);
        Integer maxH = this.getPreferredSize().height;
        if (!this.rowColHeights.containsKey(row)) {
            HashMap<Integer, Integer> colHeights = new HashMap<Integer, Integer>();
            colHeights.put(column, maxH);
            this.rowColHeights.put(row, colHeights);
            if (maxH < this.minRowHeight) {
                maxH = this.minRowHeight;
            }
            table.setRowHeight(row, maxH);
        } else {
            HashMap<Integer, Integer> colHeights = this.rowColHeights.get(row);
            colHeights.put(column, maxH);
            if (table.getRowHeight(row) > maxH) {
                for (Integer colHeight : colHeights.values()) {
                    if (colHeight <= maxH) continue;
                    maxH = colHeight;
                }
            }
            if (maxH < this.minRowHeight) {
                maxH = this.minRowHeight;
            }
            table.setRowHeight(row, maxH);
        }
        return this;
    }
}

