/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextPaneCellRenderer
implements TableCellRenderer {
    JScrollPane scrollPane;
    JTextPane textPane = new JTextPane();

    public TextPaneCellRenderer() {
        this.textPane.setEditable(false);
        this.scrollPane = new JScrollPane(this.textPane);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setBorder(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String[] cellList = (String[])value;
        String paneText = "";
        String toolText = "";
        for (int i = 0; i < cellList.length; ++i) {
            if (i == cellList.length - 1) {
                toolText = toolText + cellList[i];
                paneText = paneText + cellList[i];
                continue;
            }
            toolText = toolText + cellList[i] + ", ";
            paneText = paneText + cellList[i] + "\n";
        }
        this.textPane.setText(paneText);
        this.textPane.select(0, 0);
        StyledDocument doc = this.textPane.getStyledDocument();
        SimpleAttributeSet vCenter = new SimpleAttributeSet(this.textPane.getParagraphAttributes());
        StyleConstants.setSpaceAbove(vCenter, 2.0f);
        StyleConstants.setSpaceBelow(vCenter, 2.0f);
        doc.setParagraphAttributes(0, doc.getLength(), vCenter, false);
        this.textPane.setDocument(doc);
        this.textPane.setToolTipText(toolText);
        if (isSelected) {
            this.textPane.setForeground(table.getSelectionForeground());
            this.textPane.setBackground(table.getSelectionBackground());
            this.scrollPane.setForeground(table.getSelectionForeground());
            this.scrollPane.setBackground(table.getSelectionBackground());
        } else {
            this.textPane.setBorder(null);
            this.textPane.setForeground(table.getForeground());
            this.textPane.setBackground(table.getBackground());
            this.scrollPane.setForeground(table.getForeground());
            this.scrollPane.setBackground(table.getBackground());
        }
        return this.scrollPane;
    }
}

